@extends('admin.layout.index')

{{-- ===========  meta Title  =================== --}}
@section('title')
    اطلاعات فرم ارسالی
@endsection
@section('style')
    @include('admin.sellers.style')
@endsection

@section('script')
    <script src="{{ asset('admin/js/leaflet.js') }}"></script>
    <!-- Link to Select2 JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/js/select2.min.js"></script>
    <script>

        let is_seller = "{{ $is_seller }}";

        if (is_seller == 1) {
            DeactiveForm();
        }

        fade_page();
        function fade_page() {
            $('.page-fade').show();
            $('#page-fade-loader').show();
        }


        // آرایه‌ای از مقادیر مورد نظر
        let selectedFields = {!! json_encode($selectedFields) !!} || []; // اطمینان از این که متغیر یک آرایه جاوااسکریپتی است

        // حذف نقل قول‌ها و کاما از هر عنصر
        if (Array.isArray(selectedFields)) {
            selectedFields = selectedFields.map(field => field.replaceAll('"', '').replaceAll(',', ''));
        } else {
            console.error('selectedFields باید یک آرایه باشد');
        }

        // اگر selectedFields یک رشته باشد، به آرایه‌ای تقسیم می‌شود
        const fieldsArray = typeof selectedFields === 'string' ? selectedFields.split(",") : selectedFields;


        function checkCheckboxes() {
            // برای هر چک باکس
            fieldsArray.forEach(field => {
                const checkbox = document.querySelector(`input[type="checkbox"][value="${field}"]`);

                if (checkbox) {
                    checkbox.checked = true; // چک باکس را انتخاب می‌کند
                }
            });
            collectCheckedNames();
            fade_out_page();
        }


        // این تابع را در زمان بارگذاری صفحه صدا بزنید


        let checkedNames = [];


        function collectCheckedNames() {
            $('.highlight').removeClass('highlight')
            checkedNames = []; // Reset the array
            // همه چک باکس‌های انتخاب شده را دریافت می‌کنیم
            const checkboxes = document.querySelectorAll('input[type="checkbox"]:checked');
            // پاک‌سازی هایلایت از تمامی ورودی‌ها
            document.querySelectorAll('input[type="text"], input[type="file"]').forEach(input => {
                input.classList.remove('highlight');
                const parentId = input.id + '_parent';
                const parentElement = document.getElementById(parentId);
                if (parentElement) {
                    parentElement.classList.remove('highlight');
                }
            });


            checkboxes.forEach(checkbox => {

                checkedNames.push(checkbox.value);

                const inputField = document.getElementById(checkbox.value);


                if (inputField) {

                    inputField.classList.add('highlight');


                    // اگر ورودی نوع فایل باشد

                    if (inputField.type === 'file') {

                        const parentId = inputField.id + '_parent';

                        const parentElement = document.getElementById(parentId);

                        if (parentElement) {


                            parentElement.classList.add('highlight'); // هایلایت والد


                        }

                    }

                }

            });
            // بررسی وجود city و province

            const hasCity = checkedNames.includes('city');

            const hasProvince = checkedNames.includes('province');
            if (hasCity) {
                $('#city').siblings().find('.select2-selection--single').addClass('highlight');
            }
            if (hasProvince) {
                $('#province').siblings().find('.select2-selection--single').addClass('highlight');
            }
        }

        function validate() {
            let status = check_checkboxes_checked()[0];
            let message = check_checkboxes_checked()[1];
            $('#confirmationModalText').html(message);
            inputs = JSON.stringify(checkedNames);
            checkedNames = [];
            collectCheckedNames();

            // نمایش مودال
            $('#confirmationModal').modal('show');
            const confirmBtn = document.getElementById("confirmBtn");
            const cancelBtn = document.getElementById("CloseConfirmationModal");
            const closeBtn = document.querySelector(".close-btn");


            // عمل تایید
            confirmBtn.onclick = function () {
                $('#confirmationModal').modal('hide');
                // ارسال درخواست Ajax
                $.ajax({
                    url: '{{ route('admin.representation.validate_save') }}',
                    type: 'POST',
                    data: {
                        status: status,
                        inputs: inputs,
                        _token: "{{ csrf_token() }}",
                        seller: "{{ $seller->id }}"
                    },
                    dataType: 'json',
                })
                    .then((response) => {
                        console.log(response);
                        console.log(status);
                        console.log('عملیات با موفقیت انجام شد:', response);
                        if (response[0] == 1) {
                            if (status == 4) {
                                ShowExpertModal();
                            } else {
                                // window.location.reload();
                                swal({
                                    text: "وضعیت فرم به نیاز به تکمیل اطلاعات تغییر کرد",
                                    icon: "success",
                                    buttons: 'ok',
                                }).then(() => {

                                    window.location.href = '{{ route('admin.representation.index') }}'; // هدایت به روت جدید بعد از کلیک

                                });
                            }

                        }
                    })
                    .fail((xhr, status, error) => {
                        console.error('خطا در ارسال درخواست:', error);
                        console.log('پاسخ:', xhr.responseText);
                    });
            };

            // عمل لغو
            cancelBtn.onclick = function () {
                $('#confirmationModal').modal('hide');
            };

            // بستن مودال با کلیک روی دکمه بستن
            closeBtn.onclick = function () {
                $('#confirmationModal').modal('hide');
            };
        }

        function Denied() {
            $('#RejectedSellerModal').modal('show');
        }

        $('#RejectedSellerModalDismiss').click(function () {
            $('#RejectedSellerModal').modal('hide');
        });

        $('#RejectedSellerModalBTN').click(function () {
            $.ajax({
                url: '{{ route('admin.representation.denied_seller') }}',
                type: 'POST',
                data: {
                    status: 3,
                    _token: "{{ csrf_token() }}",
                    seller: "{{ $seller->id }}"
                },
                dataType: 'json',
            })
                .then((response) => {
                    console.log('عملیات با موفقیت انجام شد:', response);
                    if (response[0] == 1) {
                        $('#َAssignExpert').modal('hide');
                        swal({
                            text: "فرم کاربر مورد نظر رد شد",
                            icon: "success",
                            buttons: 'ok',
                        }).then(() => {

                            window.location.href = '{{ route('admin.representation.index') }}'; // هدایت به روت جدید بعد از کلیک

                        });
                    }
                })
                .fail((xhr, status, error) => {
                    console.error('خطا در ارسال درخواست:', error);
                    console.log('پاسخ:', xhr.responseText);
                });
        });

        function ShowExpertModal() {
            $('#َAssignExpert').modal('show');
        }

        // $('#confirmExpertButtonClose').click(function () {
        //     $('#َAssignExpert').modal('hide');
        //     window.location.reload();
        // });

        $('#confirmExpertButton').click(function () {
            let expert_id = $('#Expert').val();
            // ارسال درخواست Ajax
            $.ajax({
                url: '{{ route('admin.representation.expert') }}',
                type: 'POST',
                data: {
                    expert_id: expert_id,
                    _token: "{{ csrf_token() }}",
                    seller: "{{ $seller->id }}"
                },
                dataType: 'json',
            })
                .then((response) => {
                    console.log('عملیات با موفقیت انجام شد:', response);
                    if (response[0] == 1) {
                        $('#َAssignExpert').modal('hide');
                        swal({
                            text: "وضعیت فرم به تایید شده تغییر کرد",
                            icon: "success",
                            buttons: 'ok',
                        }).then(() => {

                            window.location.href = '{{ route('admin.representation.index') }}'; // هدایت به روت جدید بعد از کلیک

                        });
                    }
                })
                .fail((xhr, status, error) => {
                    console.error('خطا در ارسال درخواست:', error);
                    console.log('پاسخ:', xhr.responseText);
                });
        })

        $('#confirmExpertButtonClose').click(function () {
            $('#َAssignExpert').modal('hide');
        })


        $(document).ready(function () {
            $('#province').select2();
            $('#city').select2();
        });

        window.onload = function () {
            setTimeout(function () {
                checkCheckboxes();
                let type_val = $('input[name="type"]:checked').val();
                ChangeType(type_val);
                
                 let type_javaz_val = $('input[name="javazTypeUser"]:checked').val();
                ChangejavazType(type_javaz_val);
                var map_token = 'web.85411a4ae16b4a6f90937a647ba3d9c5';
                var location = $('[name="alopeyk_location"]').val();
                var center;

                if (location.length > 0) {
                    center = [location.split('-')[0], location.split('-')[1]];
                } else {
                    center = [35.699739, 51.338097];
                }

                var map = new L.Map('map', {
                    key: map_token,
                    maptype: 'dreamy',
                    poi: true,
                    traffic: false,
                    center: center,
                    zoom: 14
                });

                // اطمینان از اینکه اندازه نقشه به درستی تنظیم شده است
                map.invalidateSize();

                var marker;
                if (location.length > 0) {
                    location = location.split('-');
                    marker = new L.Marker([location[0], location[1]]).addTo(map);
                }

                map.on('click', function (e) {
                    if (marker) {
                        map.removeLayer(marker);
                    }
                    marker = new L.Marker([e.latlng.lat, e.latlng.lng]).addTo(map);
                    $('[name="alopeyk_location"]').val(e.latlng.lat + '-' + e.latlng.lng)
                });
            }, 3000);
        };

        function DeactiveForm() {
            $('input[type="checkbox"]').remove();
            $('.rounded').addClass('border');
            $('.drop-area').addClass('border');
            $('.select2-selection--single').addClass('border');
            $('#form_validate_btn').remove();
            $('#form_edit_btn').remove();
            $('input').prop('disabled', true);
            $('select').prop('disabled', true);
            $('textarea').prop('disabled', true);
            setTimeout(function () {
                $('input[type="checkbox"]').remove();
                $('.rounded').addClass('border');
                $('.drop-area').addClass('border');
                $('.select2-selection--single').addClass('border');
                $('#form_validate_btn').remove();
                $('#form_edit_btn').remove();
                $('input').prop('disabled', true);
                $('select').prop('disabled', true);
                $('textarea').prop('disabled', true);
                $('#chat-input').prop('disabled', false);
            }, 500)
        }
    </script>
    @include('admin.sellers.script')

@endsection
{{-- ===========  CONTENT      =================== --}}

@section('content')
    <div class="page-fade"></div>
    <div class="loader" id="page-fade-loader"></div>
    @include('admin.sellers.edit_items')
@endsection



