@extends('admin.layout.index')

{{-- ===========  meta Title  =================== --}}
@section('title')
    نمایندگی ها
@endsection
{{-- ===========  My Css Style  =================== --}}
@section('style')
    <style>
        #users {
            border: 1px solid #eeeeee;
            height: auto;
            max-height: 120px;
            overflow: auto;
            display: none;
            position: absolute;
            z-index: 999;
            width: 100%;
            top: 48px;
            background-color: white;
        }


        .user {
            margin-bottom: 0;
            padding: 0.5rem;
        }

        .user:hover {
            background-color: #afb6ff;
            color: white;
            cursor: pointer;
        }
    </style>
@endsection
{{-- ===========  My JavaScript  =================== --}}

@section('script')
    <script>
        $(document).ready(function () {
            //get localStorage
            let users = JSON.parse(localStorage.getItem("users"));
            let userNameSearch = localStorage.getItem('userNameSearch');
            if (users != null) {
                $('#userNameSearch').val(userNameSearch);
                filter();
            }
        });

        function removeModal(user_id) {
            let modal = $('#remove_modal');
            modal.modal('show');
            $('#user_id').val(user_id);
        }

        function RemoveUser() {
            let user_id = $('#user_id').val();
            let modal_alert = $('#modal_alert');
            $.ajax({
                url: "{{ route('admin.user.destroy') }}",
                data: {
                    _token: "{{ csrf_token() }}",
                    user_id: user_id,
                },
                dataType: "json",
                type: 'POST',
                beforeSend: function () {

                },
                success: function (msg) {
                    if (msg) {
                        let message = msg[1];
                        if (msg[0] === 0) {
                            swal({
                                title: 'خطا',
                                text: message,
                                icon: 'error',
                                buttons: 'ok',
                            })
                        }
                        if (msg[0] === 1) {
                            swal({
                                title: 'باتشکر',
                                text: message,
                                icon: 'success',
                                timer: 3000,
                            })
                            let users = JSON.parse(localStorage.getItem("users"));
                            if (users != null) {
                                filter();
                            } else {
                                setInterval(function () {
                                    window.location.reload();
                                }, 3000)
                            }
                        }
                    }
                },
            })
        }

        function filter() {
            let name = $('#userNameSearch').val();
            let expert = $('#expert').val();
            $.ajax({
                url: "{{ route('admin.representation.get') }}",
                data: {
                    _token: "{{ csrf_token() }}",
                    name: name,
                    expert: expert,
                },
                dataType: "json",
                type: "POST",
                beforeSend: function () {
                    $("#overlay").fadeIn();
                },
                success: function (msg) {
                    if (msg[0] == 1) {
                        $('#insertRow').html(msg[1]);
                        $('.paginate').hide();
                        //clear localStorage
                        localStorage.removeItem('users');
                        localStorage.removeItem('userNameSearch');
                        //save in localStorage
                        localStorage.setItem("users", JSON.stringify(msg[1]));
                        localStorage.setItem("userNameSearch", name);
                    } else {
                        console.error(msg);
                    }
                },
                fail: function (error) {
                    console.log(error);
                }
            })
        }

        $('#clearFactorBtn').click(function () {
            //clear localStorage
            localStorage.removeItem('users');
            localStorage.removeItem('userNameSearch');
            window.location.reload();
        })

        {{--function custom_pagination(tag) {--}}
        {{--    let per_page = $(tag).val();--}}
        {{--    let url = '{{ route('admin.users.pagination',['show_per_page'=>':per_page']) }}';--}}
        {{--    url = url.replace(':per_page', per_page);--}}
        {{--    window.location.href = url;--}}
        {{--}--}}
    </script>
@endsection
{{-- ===========      CONTENT      =================== --}}
@section('content')
{{--    <div class="row d-lg-flex justify-content-between align-items-center mb-3">--}}
{{--        <div class="col-12 d-flex align-items-center align-items-end">--}}

{{--            <div class="input-group input-group-md d-flex flex-row-reverse border-radius" style="width: 500px">--}}
{{--                <input type="text" class="form-control form-control-sm"--}}
{{--                       aria-label="Sizing example input"--}}
{{--                       aria-describedby="inputGroup-sizing-lg" placeholder="جست و جوی کاربر..."--}}
{{--                       id="userNameSearch" autocomplete="off">--}}
{{--                <div class="input-group-prepend border-radius">--}}
{{--                    <span class="input-group-text" id="basic-addon2"><i class="fa fa-search"--}}
{{--                                                                        aria-hidden="true"></i></span>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--            <div>--}}
{{--                <div class="d-flex">--}}
{{--                    <button type="button" onclick="filter()" class="btn btn-sm mx-4 btn-danger mr-3">فیلتر</button>--}}
{{--                    <button type="button" id="clearFactorBtn" class="btn btn-sm btn-primary mr-1">پاکسازی</button>--}}
{{--                </div>--}}

{{--            </div>--}}

{{--        </div>--}}
{{--    </div>--}}

        <div class="row">
            <div class="col-12">
                <form
                    id="groupDelete"
                    action="#"
                    method="POST">
                    @method('delete')
                    @csrf
                    <table class="table table-bordered text-center table-striped">
                        <thead>
                        <tr>
                            <th>ردیف</th>
                            <th>نام و نام خانوادگی</th>
                            <th>کد ملی</th>
                            <th>شماره همراه</th>
                            <th>جزئیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($sellers as $key=>$seller)
                        <tr>
                            <th>
                                {{ $key+1 }}
                            </th>
                            <th>
                                {{ $seller->first_name.' '.$seller->last_name }}
                            </th>
                            <th>
                                {{ $seller->national_code }}
                            </th>
                            <th>
                                {{ $seller->cellphone }}
                            </th>
                            <th>
                                <div class="d-flex justify-content-center">
                                    <a href="{{ route('admin.representation.edit',['id'=>$seller->id,'is_seller'=>1]) }}" class="btn btn-sm btn-info ml-2">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </div>

                            </th>
                        </tr>
                        @endforeach
                        </tbody>
                    </table>
                </form>
            </div>
        </div>


    @include('admin.users.modal')
@endsection
