<script>
    $('#chat-input').val('');
    // window.addEventListener('beforeunload', function (e) {
    //
    //     // پیام پیش‌فرض مرورگر برای هشدار
    //
    //     e.preventDefault(); // برای مرورگرهای جدید
    //
    //     return 'آیا مطمئن هستید که می‌خواهید این صفحه را ببندید؟'; // مرورگر ممکن است این پیام را نادیده بگیرد
    //
    // });

    // Upload to server

    document.querySelectorAll('.drop-area').forEach(dropArea => {
        const fileInput = dropArea.querySelector('.file-input');
        const gallery = dropArea.querySelector('.gallery');
        const removeBtn = dropArea.querySelector('.remove-btn');
        dropArea.addEventListener('click', () => fileInput.click());
        fileInput.addEventListener('change', () => {
            gallery.innerHTML = '';
            const file = fileInput.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = () => {
                    const preview = document.createElement('div');
                    preview.classList.add('preview');
                    preview.innerHTML = `<img src="${reader.result}" alt="${file.name}" style="max-width: 100%; max-height: 150px;">`;
                    gallery.appendChild(preview);
                    removeBtn.style.display = 'block';
                };
                reader.readAsDataURL(file);
            }
        });

        removeBtn.addEventListener('click', () => {

            gallery.innerHTML = '';

            fileInput.value = '';

            removeBtn.style.display = 'none';

        });


        dropArea.addEventListener('dragover', event => {

            event.preventDefault();

            dropArea.classList.add('hover');

        });


        dropArea.addEventListener('dragleave', () => {

            dropArea.classList.remove('hover');

        });


        dropArea.addEventListener('drop', event => {

            event.preventDefault();

            dropArea.classList.remove('hover');

            const dt = event.dataTransfer;

            const files = dt.files;

            fileInput.files = files;

            fileInput.dispatchEvent(new Event('change'));

        });

    });

    function loader() {
        $('#confirm-btn-1').prop('disabled', true);
        $('#confirm-btn-1').html('<span class="loader"></span>');
    }

    function ConfirmStep(step) {

        remove_error();
        let start_ajax = false;
        if (step == 1) {

            start_ajax = data_step_1()[0];
            data = data_step_1()[1];
        }
        if (step == 2) {
            start_ajax = data_step_2()[0];
            data = data_step_2()[1];
        }
        if (!start_ajax) {

            // به آرامی به اولین کلاس مورد نظر اسکرول کنیم
            const target = document.querySelector('.has-error');
            if (target) {
                smoothScrollTo(target, 2000); // 500 میلی‌ثانیه زمان اسکرول
            }
        }

        if (start_ajax) {
            fade_page();
            if (step == 1) {
                $.ajax({
                    url: "{{ route('home.register_save.step1') }}",
                    dataType: "json",
                    method: "POST",
                    data: data,
                    beforeSend:
                        function () {
                            loader();
                        }

                    ,
                    success: function (msg) {
                        if (msg[0] == 1) {
                            Show_Step_2();
                        }
                    }
                    ,
                    error: function (msg) {
                        fade_out_page();
                        var errors = msg.responseJSON.errors;
                        $.each(errors, function (key, val) {
                            $('#' + key + '_error').removeClass('d-none');
                            $('#' + key + '_error').text(val[0]);
                        });
                        $('#confirm-btn-1').prop('disabled', false);
                        $('#confirm-btn-1').html('تایید');
                    }
                    ,
                })
            }
            if (step == 2) {
                form_2_ajax()
            }
        }
    }

    function form_2_ajax() {
        var formData = new FormData();
        // جمع‌آوری مقادیر ورودی‌ها
        formData.append('step', 2);
        formData.append('shop_name', document.getElementById('shop_name').value);

        formData.append('tel', document.getElementById('tel').value);

        formData.append('code_javaz', document.getElementById('code_javaz').value);

        formData.append('province', document.getElementById('province').value);

        formData.append('city', document.getElementById('city').value);

        formData.append('district', document.getElementById('district').value);

        formData.append('postal_code', document.getElementById('postal_code').value);

        formData.append('address', document.getElementById('address').value);

        formData.append('alopeyk_location', document.getElementById('alopeyk_location').value);

        formData.append('email', document.getElementById('email').value);

        formData.append('area', document.getElementById('area').value);

        formData.append('ownership', document.getElementById('ownership').value);

        formData.append('floor', document.getElementById('floor').value);

        formData.append('position_type', document.getElementById('position_type').value);

        formData.append('sheba_no', document.getElementById('sheba_no').value);

        formData.append('card_no', document.getElementById('card_no').value);

        formData.append('social_media', document.getElementById('social_media').value);

        formData.append('sabeghe', document.getElementById('sabeghe').value);

        // formData.append('brands', document.getElementById('brands').value);

        formData.append('average_sale', document.getElementById('average_sale').value);

        formData.append('are_you_sale', document.getElementById('are_you_sale').value);

        formData.append('who_sales_from', document.getElementById('who_sales_from').value);

        formData.append('description', document.getElementById('description').value);
        formData.append('_token', "{{ csrf_token() }}");
        // جمع آوری فایل‌ها
        const fileInputs = document.querySelectorAll('input[type="file"]');
        fileInputs.forEach(input => {
            if (input.files.length > 0) {
                formData.append(input.name, input.files[0]);
            }
        });
        // ارسال داده‌ها با AJAX

        $.ajax({

            url: "{{ route('home.register_save.step1') }}",

            type: 'POST',

            data: formData,

            contentType: false,

            processData: false,

            success: function (response) {
                ShowPreview();
            },
            error: function (msg) {
                fade_out_page();
                var errors = msg.responseJSON.errors;
                $.each(errors, function (key, val) {
                    $('#' + key + '_error').removeClass('d-none');
                    $('#' + key + '_error').text(val[0]);
                    const target = document.getElementById(key + '_error'); // بدون #
                    if (target) {
                        smoothScrollTo(target, 2000); // 2000 میلی‌ثانیه زمان اسکرول
                    }
                });
                $('#confirm-btn-1').prop('disabled', false);
                $('#confirm-btn-1').html('تایید');
            }

        });
    }

    function form_3_ajax() {
        fade_page();
        var formData = new FormData();
        // جمع‌آوری مقادیر ورودی‌ها
        formData.append('seller_id', {{ $seller->id }});
        formData.append('step', 5);
        //مقادیر 1
        formData.append('first_name', document.getElementById('first_name').value);
        formData.append('changes', document.getElementById('changes').value);
        formData.append('changes_files', document.getElementById('changes_files').value);
        formData.append('last_name', document.getElementById('last_name').value);
        formData.append('father_name', document.getElementById('father_name').value);
        formData.append('birth_date', document.getElementById('birth_date').value);
        formData.append('national_code', document.getElementById('national_code').value);
        formData.append('cellphone', document.getElementById('cellphone').value);
        formData.append('shomare_sabt_sherkat', document.getElementById('shomare_sabt_sherkat').value);
        formData.append('shomare_sheba_sherkat', document.getElementById('shomare_sheba_sherkat').value);
        
                formData.append('first_name_owner', document.getElementById('first_name_owner').value);
        formData.append('last_name_owner', document.getElementById('last_name_owner').value);
                formData.append('national_code_owner', document.getElementById('national_code_owner').value);
        
        formData.append('shenase_meli', document.getElementById('shenase_meli').value);
        let type = $('input[name="type"]:checked').val();
        formData.append('type', type);

        //مقادیر 2
        formData.append('shop_name', document.getElementById('shop_name').value);

        formData.append('tel', document.getElementById('tel').value);

        formData.append('code_javaz', document.getElementById('code_javaz').value);

        formData.append('province', document.getElementById('province').value);

        formData.append('city', document.getElementById('city').value);

        formData.append('district', document.getElementById('district').value);

        formData.append('postal_code', document.getElementById('postal_code').value);

        formData.append('address', document.getElementById('address').value);

        formData.append('alopeyk_location', document.getElementById('alopeyk_location').value);

        formData.append('email', document.getElementById('email').value);

        formData.append('area', document.getElementById('area').value);

        formData.append('ownership', document.getElementById('ownership').value);

        formData.append('floor', document.getElementById('floor').value);

        formData.append('position_type', document.getElementById('position_type').value);

        formData.append('sheba_no', document.getElementById('sheba_no').value);

        formData.append('card_no', document.getElementById('card_no').value);

        formData.append('social_media', document.getElementById('social_media').value);

        formData.append('sabeghe', document.getElementById('sabeghe').value);

        // formData.append('brands', document.getElementById('brands').value);

        formData.append('average_sale', document.getElementById('average_sale').value);

        formData.append('are_you_sale', document.getElementById('are_you_sale').value);

        formData.append('who_sales_from', document.getElementById('who_sales_from').value);

        formData.append('description', document.getElementById('description').value);

        formData.append('_token', "{{ csrf_token() }}");
        // جمع آوری فایل‌ها
        const fileInputs = document.querySelectorAll('input[type="file"]');
        fileInputs.forEach(input => {
            if (input.files.length > 0) {
                formData.append(input.name, input.files[0]);
            }
        });
        // ارسال داده‌ها با AJAX
        // مشخص کردن آدرس Blob

        const audioElement = document.getElementById('audio');
        if (audioElement != null) {
            const audioSrc = audioElement.src;


            // بررسی وجود منبع صوتی

            if (audioSrc && audioSrc.startsWith('blob:')) {

                // دریافت Blob از URL Blob

                fetch(audioSrc)

                    .then(response => response.blob())

                    .then(audioBlob => {

                        // اضافه کردن Blob به FormData

                        formData.append('audio', audioBlob, 'recording.wav');


                        // ارسال داده‌ها با AJAX

                        sendData(formData);

                    })

                    .catch(error => {

                        console.error('Error processing blob:', error);

                    });

            } else {

                // اگر منبع صوتی وجود نداشت، فقط ارسال کنید

                sendData(formData);

            }
        } else {
            sendData(formData);
        }


    }
    
    function edit_ajax() {
        fade_page();
        var formData = new FormData();
        // جمع‌آوری مقادیر ورودی‌ها
        formData.append('seller_id', {{ $seller->id }});
        formData.append('step', 5);
        formData.append('edit', 1);
        //مقادیر 1
        formData.append('first_name', document.getElementById('first_name').value);
        formData.append('changes', document.getElementById('changes').value);
        formData.append('changes_files', document.getElementById('changes_files').value);
        formData.append('last_name', document.getElementById('last_name').value);
        formData.append('father_name', document.getElementById('father_name').value);
        formData.append('birth_date', document.getElementById('birth_date').value);
        formData.append('national_code', document.getElementById('national_code').value);
        formData.append('cellphone', document.getElementById('cellphone').value);
        
        formData.append('shomare_sabt_sherkat', document.getElementById('shomare_sabt_sherkat').value);
        formData.append('shomare_sheba_sherkat', document.getElementById('shomare_sheba_sherkat').value);
                
        formData.append('last_name_owner', document.getElementById('last_name_owner').value);
        formData.append('first_name_owner', document.getElementById('first_name_owner').value);
                formData.append('national_code_owner', document.getElementById('national_code_owner').value);

        formData.append('shenase_meli', document.getElementById('shenase_meli').value);
        let type = $('input[name="type"]:checked').val();
        formData.append('type', type);

        //مقادیر 2
        formData.append('shop_name', document.getElementById('shop_name').value);

        formData.append('tel', document.getElementById('tel').value);

        formData.append('code_javaz', document.getElementById('code_javaz').value);

        formData.append('province', document.getElementById('province').value);

        formData.append('city', document.getElementById('city').value);

        formData.append('district', document.getElementById('district').value);

        formData.append('postal_code', document.getElementById('postal_code').value);

        formData.append('address', document.getElementById('address').value);

        formData.append('alopeyk_location', document.getElementById('alopeyk_location').value);

        formData.append('email', document.getElementById('email').value);

        formData.append('area', document.getElementById('area').value);

        formData.append('ownership', document.getElementById('ownership').value);

        formData.append('floor', document.getElementById('floor').value);

        formData.append('position_type', document.getElementById('position_type').value);

        formData.append('sheba_no', document.getElementById('sheba_no').value);

        formData.append('card_no', document.getElementById('card_no').value);

        formData.append('social_media', document.getElementById('social_media').value);

        formData.append('sabeghe', document.getElementById('sabeghe').value);

        // formData.append('brands', document.getElementById('brands').value);

        formData.append('average_sale', document.getElementById('average_sale').value);

        formData.append('are_you_sale', document.getElementById('are_you_sale').value);

        formData.append('who_sales_from', document.getElementById('who_sales_from').value);

        formData.append('description', document.getElementById('description').value);

        formData.append('_token', "{{ csrf_token() }}");
        // جمع آوری فایل‌ها
        const fileInputs = document.querySelectorAll('input[type="file"]');
        fileInputs.forEach(input => {
            if (input.files.length > 0) {
                formData.append(input.name, input.files[0]);
            }
        });
        // ارسال داده‌ها با AJAX
        // مشخص کردن آدرس Blob

        const audioElement = document.getElementById('audio');
        if (audioElement != null) {
            const audioSrc = audioElement.src;


            // بررسی وجود منبع صوتی

            if (audioSrc && audioSrc.startsWith('blob:')) {

                // دریافت Blob از URL Blob

                fetch(audioSrc)

                    .then(response => response.blob())

                    .then(audioBlob => {

                        // اضافه کردن Blob به FormData

                        formData.append('audio', audioBlob, 'recording.wav');


                        // ارسال داده‌ها با AJAX

                        sendData(formData);

                    })

                    .catch(error => {

                        console.error('Error processing blob:', error);

                    });

            } else {

                // اگر منبع صوتی وجود نداشت، فقط ارسال کنید

                sendData(formData);

            }
        } else {
            sendData(formData);
        }


    }

    $('.form-control').change(function () {
        $(this).addClass('highlight');
    })

    $('input[type="file"]').click(function () {
        $(this).parent().addClass('highlight');
        $(this).parent().find('.upload_div_icon').addClass('d-none');
    })

    function sendData(formData) {

        $.ajax({

            url: "{{ route('home.register_save.step1') }}",

            type: 'POST',

            data: formData,

            contentType: false,

            processData: false,

            success: function (response) {

                if (response[0] == 1) {
                    @if(auth()->guard('seller')->check())
                    swal({
                        text: "تغییرات با موفقیت اعمال شد.لطفا منتظر بررسی و اطلاع رسانی ناظر بمانید",
                        icon: "success",
                        buttons: 'متوجه شدم',
                    }).then(function () {
                        window.location.reload();
                    })
                    @else
                    swal({
                        text: "وضعیت فرم درخواست نماینده بروزرسانی شد",
                        icon: "success",
                        buttons: 'متوجه شدم',
                    }).then(function () {
                        window.location.reload();
                    })
                    @endif

                }
                if (response[0] == 3) {
                    if (response[1]!=false) {
                        const modifiedFields = response[1].map(field => {
                            $(`input[name="${field}"]`).removeClass('highlight');
                        });
                        swal({
                            text: "فیلد های مشخص شده(قرمز رنگ) نیاز به تکمیل و به روزرسانی دارند",
                            icon: "error",
                            buttons: 'متوجه شدم',
                        }).then(function () {
                            fade_out_page();
                        })
                    }
                    if (response[2]!=false) {
                        const modifiedFields = response[2].map(field => {
                            $(`input[name="${field}"]`).parent().removeClass('highlight');
                            $(`input[name="${field}"]`).parent().find('.upload_div_icon').removeClass('d-none');
                        });
                        swal({
                            text: "فیلد های مشخص شده(قرمز رنگ) نیاز به تکمیل و به روزرسانی دارند",
                            icon: "error",
                            buttons: 'متوجه شدم',
                        }).then(function () {
                            fade_out_page();
                        })
                    }


                }

            },

            error: function (msg) {
                fade_out_page();
                var errors = msg.responseJSON.errors;

                $.each(errors, function (key, val) {

                    $('#' + key + '_error').removeClass('d-none');

                    $('#' + key + '_error').text(val[0]);

                    const target = document.getElementById(key + '_error'); // بدون #

                    if (target) {

                        smoothScrollTo(target, 2000); // 2000 میلی‌ثانیه زمان اسکرول

                    }

                });

                $('#confirm-btn-1').prop('disabled', false);

                $('#confirm-btn-1').html('تایید');

            }

        });

    }

    function data_step_1() {

        let first_name = $('#first_name').val();
        let last_name = $('#last_name').val();
        let national_code = $('#national_code').val();
        let cellphone = $('#cellphone').val();
        let javazType = $('input[name="javazTypeUser"]:checked').val();
         let type = $('input[name="type"]:checked').val();
        let start_ajax = true;
        
        let shomare_sheba_sherkat = $('#shomare_sheba_sherkat').val();
        let shomare_sabt_sherkat = $('#shomare_sabt_sherkat').val();
        
        let first_name_owner = $('#first_name_owner').val();
        let last_name_owner = $('#last_name_owner').val();
        let national_code_owner = $('#national_code_owner').val();
        
        let shenase_meli = $('#shenase_meli').val();

        if (first_name.length == 0) {
            $('#first_name').addClass('has-error');
            start_ajax = false;
        }
        if (last_name.length == 0) {
            $('#last_name').addClass('has-error');
            start_ajax = false;
        }
        if (national_code.length == 0) {
            $('#national_code').addClass('has-error');
            start_ajax = false;
        }
        if (cellphone.length == 0) {
            $('#cellphone').addClass('has-error');
            start_ajax = false;
        }
        if (typeof type == "undefined") {
            $('#type').addClass('has-error');
            start_ajax = false;
        }
        if (type == 2) {
            if (shomare_sabt_sherkat.length == 0) {
                $('#shomare_sabt_sherkat').addClass('has-error');
                start_ajax = false;
            }
            if(shomare_sheba_sherkat.length == 0){
                $('#shomare_sheba_sherkat').addClass('has-error');
                start_ajax = false;
            }
            if (shenase_meli.length == 0) {
                $('#shenase_meli').addClass('has-error');
                start_ajax = false;
            }
        }
        
                if (javazType == 0) {
            if (first_name_owner.length == 0) {
                $('#first_name_owner').addClass('has-error');
                start_ajax = false;
            }
            if(last_name_owner.length == 0){
                $('#last_name_owner').addClass('has-error');
                start_ajax = false;
            }
            if(national_code_owner.length == 0){
                $('#national_code_owner').addClass('has-error');
                start_ajax = false;
            }

        }
        cellphone = cellphone_check(cellphone);
        return [start_ajax, {
            step: 1,
            _token: "{{ csrf_token() }}",
            first_name: first_name,
            last_name: last_name,
            national_code: national_code,
            cellphone: cellphone,
            type: type,
            shomare_sabt_sherkat: shomare_sabt_sherkat,
            shomare_sheba_sherkat:shomare_sheba_sherkat,
            first_name_owner,
            last_name_owner,
            national_code_owner,
            shenase_meli: shenase_meli,
        }]
    }

    function data_step_2() {
        
        let start_ajax = true;
        let shop_name = $('#shop_name').val();
        if (shop_name.length == 0) {
            $('#shop_name').addClass('has-error');
            start_ajax = false;
        }
        let tel = $('#tel').val();
        if (tel.length == 0) {
            $('#tel').addClass('has-error');
            start_ajax = false;
        }
        let code_javaz = $('#code_javaz').val();
        if (code_javaz.length == 0) {
            $('#code_javaz').addClass('has-error');
            start_ajax = false;
        }
        let axe_javaz = $('#axe_javaz')[0].files.length;
        if (axe_javaz == 0) {
            $('#axe_javaz_parent').addClass('has-error');
            start_ajax = false;
        }
        let province = $('#province').val();
        if (province.length == 0) {
            $('#province').next().find('.select2-selection--single').addClass('has-error');
            start_ajax = false;
        }
        let city = $('#city').val();
        if (city.length == 0) {
            $('#city').next().find('.select2-selection--single').addClass('has-error');
            start_ajax = false;
        }
        let district = $('#district').val();
        if (district.length == 0) {
            $('#district').addClass('has-error');
            start_ajax = false;
        }
        let postal_code = $('#postal_code').val();
        if (postal_code.length == 0) {
            $('#postal_code').addClass('has-error');
            start_ajax = false;
        }
        let address = $('#address').val();
        if (address.length == 0) {
            $('#address').addClass('has-error');
            start_ajax = false;
        }

        let alopeyk_location = $('#alopeyk_location').val();
        if (alopeyk_location.length == 0) {
            $('#map').addClass('has-error');
            start_ajax = false;
        }

        let email = $('#email').val();
        if (email.length == 0) {
            $('#email').addClass('has-error');
            start_ajax = false;
        }
        let area = $('#area').val();
        if (area.length == 0) {
            $('#area').addClass('has-error');
            start_ajax = false;
        }
        let ownership = $('#ownership').val();
        if (ownership.length == 0) {
            $('#ownership').addClass('has-error');
            start_ajax = false;
        }
        let floor = $('#floor').val();
        if (floor.length == 0) {
            $('#floor').addClass('has-error');
            start_ajax = false;
        }
        let position_type = $('#position_type').val();
        if (position_type.length == 0) {
            $('#position_type').addClass('has-error');
            start_ajax = false;
        }

        let outer_image = $('#outer_image')[0].files.length;
        if (outer_image == 0) {
            $('#outer_image_parent').addClass('has-error');
            start_ajax = false;
        }

        let head_image = $('#head_image')[0].files.length;
        if (head_image == 0) {
            $('#head_image_parent').addClass('has-error');
            start_ajax = false;
        }
        let inner_image = $('#inner_image')[0].files.length;
        if (inner_image == 0) {
            $('#inner_image_parent').addClass('has-error');
            start_ajax = false;
        }
        let visit_card_image = $('#visit_card_image')[0].files.length;
        if (visit_card_image == 0) {
            $('#visit_card_image_parent').addClass('has-error');
            start_ajax = false;
        }
        let melli_card_image = $('#melli_card_image')[0].files.length;
        if (melli_card_image == 0) {
            $('#melli_card_image_parent').addClass('has-error');
            start_ajax = false;
        }
        let shenasname_image = $('#shenasname_image')[0].files.length;
        if (shenasname_image == 0) {
            $('#shenasname_image_parent').addClass('has-error');
            start_ajax = false;
        }

        let sanad_image = $('#sanad_image')[0].files.length;
        if (sanad_image == 0) {
            $('#sanad_image_parent').addClass('has-error');
            start_ajax = false;
        }

        let sheba_no = $('#sheba_no').val();
        if (sheba_no.length == 0) {
            $('#sheba_no').addClass('has-error');
            start_ajax = false;
        }
        let card_no = $('#card_no').val();
        if (card_no.length == 0) {
            $('#card_no').addClass('has-error');
            start_ajax = false;
        }
        let social_media = $('#social_media').val();
        if (social_media.length == 0) {
            $('#social_media').addClass('has-error');
            start_ajax = false;
        }
        let sabeghe = $('#sabeghe').val();
        if (sabeghe.length == 0) {
            $('#sabeghe').addClass('has-error');
            start_ajax = false;
        }
        // let brands = $('#brands').val();
        // if (brands.length == 0) {
        //     $('#brands').addClass('has-error');
        //     start_ajax = false;
        // }
        let are_you_sale = $('#are_you_sale').val();
        if (are_you_sale.length == 0) {
            $('#are_you_sale').addClass('has-error');
            start_ajax = false;
        }
        let who_sales_from = $('#who_sales_from').val();
        if (who_sales_from.length == 0  ) {
         
            $('#who_sales_from').addClass('has-error');
            start_ajax = false;
        }
        let average_sale = $('#average_sale').val();
        if (average_sale.length == 0) {
            $('#average_sale').addClass('has-error');
            start_ajax = false;
        }
        let description = $('#description').val();
        console.log(description);
        // if (description.length == 0) {
        //     $('#description').addClass('has-error');
        //     start_ajax = false;
        // }

        return [start_ajax, 'pppp']
    }

    function Show_Step_2() {
        $('#confirm-btn-1').prop('disabled', false);
        $('#confirm-btn-1').html('تایید');
        fade_page();
        setTimeout(function () {
            fade_out_page();
            $('#step-1').addClass('d-none');
            $('#step-3').addClass('d-none');
            $('#step-2').removeClass('d-none');
            const target = document.getElementById('form-step-2'); // بدون #
            if (target) {
                smoothScrollTo(target, 2000); // 2000 میلی‌ثانیه زمان اسکرول
            }
        }, 1000);

    }

    function fade_page() {
        $('.page-fade').show();
        $('#page-fade-loader').show();
    }

    function fade_out_page() {
        $('.page-fade').hide();
        $('#page-fade-loader').hide();
    }

    function ChangeType(val) {
        $('#shenase_meli_parent').addClass('d-none');
        $('#shomare_sabt_sherkat_parent').addClass('d-none');
        $('#shomare_sheba_sherkat_parent').addClass('d-none');

        if (val == 2) {
            $('#shenase_meli_parent').removeClass('d-none');
            $('#shomare_sheba_sherkat_parent').removeClass('d-none');
            $('#shomare_sabt_sherkat_parent').removeClass('d-none');
        }
    }
    
        function ChangejavazType(val) {
        $('#first_name_owner_parent').addClass('d-none');
        $('#last_name_owner_parent').addClass('d-none');
             $('#national_code_owner_parent').addClass('d-none');


        if (val == 0) {
            $('#first_name_owner_parent').removeClass('d-none');
            $('#last_name_owner_parent').removeClass('d-none');
              $('#national_code_owner_parent').removeClass('d-none');

        }
    }

    function ProvinceChanged(tag) {
        let province_id = $(tag).val();
        $.ajax({
            url: "{{ route('home.register.getCities') }}",
            method: "post",
            dataType: "json",
            data: {
                province_id: province_id,
                _token: "{{ csrf_token() }}"
            },
            success: function (data) {
                $('#city').html(data[1]);
                $('#city').select2();
            }
        })
    }

    function remove_error() {
        $('.has-error').removeClass('has-error');
        // $('#type').removeClass('has-error');
        $('.validate').addClass('d-none');
    }

    function cellphone_check(cellphone) {
        cellphone = cellphone.replaceAll('+98', 0);

        let first_characters = cellphone.substring(0, 2);
        let last_characters = cellphone.substring(2);

        if (first_characters == 98) {
            cellphone = 0 + last_characters;
        }
        let first_char = Array.from(cellphone)[0];
        if (first_char != 0) {
            cellphone = 0 + cellphone;
        }
        $('#cellphone').val(cellphone);
        return cellphone;

    }

    function PreviousStep(step) {
        fade_page();
        setTimeout(function () {
            let next_step = step + 1;
            fade_out_page();
            $('#step-' + next_step).addClass('d-none');
            $('#step-' + step).removeClass('d-none');
        }, 1000);
    }

    function smoothScrollTo(element, duration) {

        const start = window.scrollY;

        const end = element.getBoundingClientRect().top - 100 + start;

        const distance = end - start;

        const startTime = performance.now();


        function animation(currentTime) {

            const timeElapsed = currentTime - startTime;

            const progress = Math.min(timeElapsed / duration, 1);

            const movement = distance * easeInOutCubic(progress);


            window.scrollTo(0, start + movement);


            if (timeElapsed < duration) {

                requestAnimationFrame(animation);

            }

        }


        requestAnimationFrame(animation);

    }

    // تابع انیمیشن easeInOutCubic
    function easeInOutCubic(t) {

        return t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;

    }

    function ShowPreview() {
        // جمع‌آوری HTML مرحله اول و مرحله دوم
        let step_1_html = $('#form-step-1').html();
        let step_2_html = $('#form-step-2').html();

        // جمع‌آوری مقادیر input، textarea و select از هر دو فرم
        let inputsAndTextareas = $('#form-step-1 input, #form-step-2 input, #form-step-1 textarea, #form-step-2 textarea, #form-step-1 select, #form-step-2 select');
        let values = {};

        inputsAndTextareas.each(function () {
            let name = $(this).attr('name');
            if (name) {
                // اگر ورودی نوع file نیست
                if ($(this).attr('type') !== 'file') {
                    if ($(this).is(':radio')) {
                        // اگر input نوع radio باشد، مقدار انتخاب شده را ذخیره می‌کنیم
                        if ($(this).is(':checked')) {
                            values[name] = $(this).val();
                        }
                    } else if ($(this).is(':checkbox')) {
                        // اگر input نوع checkbox باشد، مقدار را ذخیره می‌کنیم
                        values[name] = $(this).is(':checked') ? $(this).val() : '';
                    } else {
                        // برای سایر input ها و textarea ها
                        values[name] = $(this).val();
                    }
                }
            }
        });

        let step_3_html = step_1_html + step_2_html;
        fade_page();
        setTimeout(function () {
            fade_out_page();
            $('#step-1').addClass('d-none');
            $('#step-2').addClass('d-none');
            $('#form-step-3').html(step_3_html);
            // حذف هر عنصر با id از $('#form-step-3')
            $('#form-step-3 [id]').removeAttr('id');
            // حذف هر عنصر با onclick از $('#form-step-3')
            $('#form-step-3 [onclick]').removeAttr('onclick');
            $('#form-step-3 .confirm_btn').addClass('d-none');
            disableInputs();
            $('#form-step-3').removeClass('d-none');
            $('#form-step-3').find('.remove-btn').remove();
            $('#form-step-3').find('.select2-selection--single').addClass('disabled');
            $('#step-3').removeClass('d-none');
            // دوباره بارگذاری مقادیر input ها، textarea ها و select ها در مرحله 3
            $('#form-step-3 input, #form-step-3 textarea, #form-step-3 select').each(function () {
                let name = $(this).attr('name');
                if (values[name] !== undefined) {
                    if ($(this).is(':radio')) {
                        // اگر input نوع radio باشد، انتخاب را انجام می‌دهیم
                        if ($(this).val() === values[name]) {
                            $(this).prop('checked', true);
                        }
                    } else if ($(this).is(':checkbox')) {
                        // اگر input نوع checkbox باشد، انتخاب را انجام می‌دهیم
                        $(this).prop('checked', values[name] !== '');
                    } else {
                        $(this).val(values[name]);
                    }
                }
                const target = document.getElementById('form-step-3'); // بدون #
                if (target) {
                    smoothScrollTo(target, 2000); // 2000 میلی‌ثانیه زمان اسکرول
                }
            });
        }, 1500);
    }


    function disableInputs() {
        // غیر فعال کردن تمام input ها و textarea ها
        $('#form-step-3 input,#form-step-3 textarea,#form-step-3 select').prop('disabled', true).addClass('disabled');
        // غیر فعال کردن drop zone (در صورت نیاز)
        $('#form-step-3 .drop-zone').addClass('disabled'); // فرض بر این است که کلاس drop zone 'drop-zone' است
        $('#form-step-3 .record-button,#form-step-3 .delete-button,#form-step-3 .timer').addClass('d-none');
    }


</script>

{{--    //map--}}
<script>

    {{--    //ضبط صدا--}}

    let mediaRecorder;

    let audioChunks = [];

    let timerInterval;

    let seconds = 0;


    async function startRecording() {

        const recordButton = document.getElementById('record');

        const deleteButton = document.getElementById('delete');

        try {

            const stream = await navigator.mediaDevices.getUserMedia({audio: true});

            mediaRecorder = new MediaRecorder(stream);

            audioChunks = [];


            mediaRecorder.ondataavailable = event => {

                audioChunks.push(event.data);

            };


            mediaRecorder.onstop = () => {

                clearInterval(timerInterval);

                const audioBlob = new Blob(audioChunks, {type: 'audio/wav'});

                const audioUrl = URL.createObjectURL(audioBlob);

                const audio = document.getElementById('audio');

                audio.src = audioUrl;

                audio.style.display = 'block';


                // نمایش دکمه حذف

                deleteButton.style.display = 'block';


                recordButton.classList.remove('recording');

                recordButton.innerHTML = '<i class="fas fa-microphone-alt"></i>';

                document.getElementById('timer').textContent = '00:00';

                seconds = 0;

            };


            mediaRecorder.start();

            recordButton.classList.add('recording');

            recordButton.innerHTML = '<i class="fas fa-stop"></i>';


            seconds = 0;

            timerInterval = setInterval(() => {

                seconds++;

                const minutes = Math.floor(seconds / 60);

                const secs = seconds % 60;

                document.getElementById('timer').textContent = `${String(minutes).padStart(2, '0')}:${String(secs).padStart(2, '0')}`;

            }, 1000);


            recordButton.onclick = () => {

                mediaRecorder.stop();

                recordButton.onclick = startRecording;

            };

        } catch (error) {

            console.error("خطا در دسترسی به میکروفن:", error);

            alert("دسترسی به میکروفن رد شد یا مشکلی پیش آمد.");

        }

    }


    function deleteAudio() {

        const audio = document.getElementById('audio');

        const deleteButton = document.getElementById('delete');

        audio.src = '';

        audio.style.display = 'none';

        deleteButton.style.display = 'none';

    }


    // document.getElementById('record').onclick = startRecording;
    //
    // document.getElementById('delete').onclick = deleteAudio; // رویداد دکمه حذف

    function check_checkboxes_checked() {
        let status = 0;
        let message;

        // تمام چک باکس‌ها را انتخاب کنید بر اساس شرایط
        let checkboxes = $('input[type="checkbox"]:not([value="shenase_meli"]):not([value="shomare_sabt_sherkat"]):not([value="1"]):not([value="shomare_sheba_sherkat"]):not([value="national_code_owner"]):not([value="first_name_owner"]):not([value="last_name_owner"])');
        if ($('input[name="type"]:checked').val() == 2) {
            checkboxes = $('input[type="checkbox"]:not([value="1"]):not([value="first_name_owner"]):not([value="last_name_owner"]):not([value="national_code_owner"])');
        }
       
               if ($('input[name="javazTypeUser"]:checked').val() == 0) {
            checkboxes = $('input[type="checkbox"]:not([value="1"]):not([value="shenase_meli"]):not([value="shomare_sabt_sherkat"]):not([value="shomare_sheba_sherkat"])');
        }
        if($('input[name="javazTypeUser"]:checked').val() == 0 && $('input[name="type"]:checked').val() == 2){
                        checkboxes = $('input[type="checkbox"]:not([value="1"])');

        }

        // بررسی اینکه آیا همه چک باکس‌ها تیک خورده‌اند یا خیر
        const allChecked = checkboxes.toArray().every(checkbox => checkbox.checked);
        console.log(allChecked,checkboxes);

        if (allChecked) {
            console.log("همه چک باکس‌ها تیک خورده‌اند! ✅");
            status = 4;
            message = 'شما تمامی موارد ارسالی را تایید کرده اید.' +
                '<br>' +
                '<div class="alert alert-success text-center mt-3">وضعیت فرم به <strong>امضاء قرارداد </strong> تغییر پیدا خواهد کرد</div>';
        } else {
            console.log("تمام چک باکس‌ها تیک نخورده‌اند! ❌");
            status = 1;
            message = 'شما برخی موارد ارسالی را تایید نکرده اید.' +
                '<br>' +
                '<div class="alert alert-danger text-center mt-3">وضعیت فرم به <strong>نیاز به تکمیل</strong> تغییر پیدا خواهد کرد</div>';
        }

        return [status, message];
    }

    function sendMessage() {
        var message = $('#chat-input').val();
        let seller_id = "{{ $seller->id }}";
        let url = "{{ route('admin.representation.chat') }}"
        let current_url = window.location.pathname;
        let is_admin = current_url.startsWith('/admin-panel') ? 1 : 0;

        // ارسال پیام به سرور با استفاده از AJAX
        $.ajax({
            url: url, // آدرس مناسب برای API لاراول
            method: 'POST',
            data: {
                message: message,
                seller_id: seller_id,
                is_admin: is_admin,
                _token: '{{ csrf_token() }}' // توکن CSRF Laravel
            },
            success: function (response) {
                console.log(response);
                $('#chat-input').val(''); // پاک کردن فیلد ورودی
                $('#chat-messages').html(response.html);
                $('#chat_history').html(response.chat_history);

                $('#chat-messages').scrollTop($('#chat-messages')[0].scrollHeight);

            },
            error: function (xhr) {

                showWarningModal('مشکلی در ارسال پیام پیش آمد.');

            }

        });
    }


    function showWarningModal(message) {
        $('#chat-input-error').hide(); // مخفی کردن پیام خطا
        let message_2 = $('#chat-input').val(); // دریافت مقدار از فیلد ورودی
        console.log(message_2);

        if (message_2.length < 3) {
            $('#chat-input-error').show(); // نمایش پیام خطا در صورت کم بودن طول پیام
        } else {
            $('#warningModal .modal-body').text(message); // قرار دادن پیام در مودال
            $('#warningModal').modal('show'); // نمایش مودال
        }
    }


    $('#chat-send-btn').click(function () {
        //
        // showWarningModal('آیا از ارسال این پیام مطمئن هستید؟');
        sendMessage();
    });


    $('#confirmSendButton').click(function () {

        $('#warningModal').modal('hide');

        sendMessage();

    });


    $('#chat-input').keypress(function (e) {

        if (e.which === 13) { // Enter key

            e.preventDefault(); // جلوگیری از رفتار پیش‌فرض
            //
            // showWarningModal('آیا از ارسال این پیام مطمئن هستید؟');
            sendMessage();

        }

    });

    function ShowChat() {
        setTimeout(function () {
            $('#chat-messages').animate({
                scrollTop: $('#chat-messages')[0].scrollHeight
            }, 1000); // مدت زمان حرکت به میلی ثانیه
        }, 1000);

        let current_url = window.location.pathname;
        let is_admin = current_url.startsWith('/admin-panel') ? 1 : 0;
        let seller_id = "{{ $seller->id }}";
        let url = "{{ route('admin.representation.chat_seen') }}"
        $.ajax({
            url: url, // آدرس مناسب برای API لاراول
            method: 'POST',
            data: {
                seller_id: seller_id,
                is_admin: is_admin,
                _token: '{{ csrf_token() }}' // توکن CSRF Laravel
            },
            success: function (response) {
                if (response.success) {
                    setTimeout(function () {
                        $('.notification-badge').remove();
                    }, 3000);
                }
            },
            error: function (xhr) {

                showWarningModal('مشکلی در ارسال پیام پیش آمد.');

            }

        });
    }

    function GoToDate(tag, dateID) {
        // حذف کلاس btn-active از تمام دکمه‌ها
        $('.date-link').removeClass('btn-active');
        $(tag).addClass('btn-active');

        // پیدا کردن تگ هدف
        let target = $('#date-' + dateID)[0];

        if (target) {
            console.log('pll');
            // محاسبه موقعیت اسکرول
            const chatMessages = document.getElementById('chat-messages');
            const targetPosition = target.offsetTop - 60; // کاهش 50 پیکسل از موقعیت هدف

            // اسکرول به تگ مربوط
            chatMessages.scrollTo({
                top: targetPosition,
                behavior: 'smooth' // اسکرول نرم
            });
        } else {
            console.log("هدف پیدا نشد!");
        }
    }
</script>
