@extends('admin.layout.index')

{{-- ===========  meta Title  =================== --}}
@section('title')
    تنظیمات پنل نمایندگان
@endsection
@section('style')

@endsection

@section('script')


@endsection
{{-- ===========  CONTENT      =================== --}}

@section('content')
    <form action="{{ route('admin.representation.settings.store') }}" method="post">
        @csrf
        <div class="row">

            <div class="col-12 col-md-6 col-lg-3 mb-2">

                <label for="commission_installment" class="mb-2">

                    پوسانت فروش اقساطی (%)

                    <sup class="input-error-validation">*</sup>

                </label>

                <input min="0" max="100" name="commission_installment" id="commission_installment" type="text" class="form-control rounded"
                       value="{{ $commission_installment }}">
                @error('commission_installment')
                <p class="input-error-validation">{{ $message }}</p>
                @enderror
            </div>
            <div class="col-12 col-md-6 col-lg-3 mb-2">
                <label for="order_status" class="mb-2">
                  وضعیت محاسبه پورسانت سفارش اقساطی
                    <sup class="input-error-validation">*</sup>
                </label>
                <select name="order_status" id="order_status" class="form-control rounded">
                    <!-- فرض می‌کنیم که $order_status یک آرایه از انواع پرداخت است -->
                    @foreach($order_status as  $label)
                        <option value="{{ $label->id }}" {{ old('order_status', $current_order_status) == $label->id ? 'selected' : '' }}>
                            {{ $label->title }}
                        </option>
                    @endforeach
                </select>
                @error('order_status')
                <p class="input-error-validation">{{ $message }}</p>
                @enderror
            </div>


            <div class="col-12 col-md-6 col-lg-3 mb-2">

                <label for="commission" class="mb-2">

                    پوسانت فروش نقدی (%)

                    <sup class="input-error-validation">*</sup>

                </label>

                <input min="0" max="100" name="commission" id="commission" type="text" class="form-control rounded"
                       value="{{ $commission }}">
                @error('commission')
                <p class="input-error-validation">{{ $message }}</p>
                @enderror
            </div>
            <div class="col-12 col-md-6 col-lg-3 mb-2">

                <label for="start_request_cache_date" class="mb-2">

                    شروع بازه زمانی درخواست پول (هر ماه)

                    <sup class="input-error-validation">*</sup>

                </label>

                <input name="start_request_cache_date" id="start_request_cache_date" type="text"
                       class="form-control rounded" value="{{ $start_request_cache_date }}" placeholder="10">
                @error('start_request_cache_date')
                <p class="input-error-validation">{{ $message }}</p>
                @enderror
            </div>
            <div class="col-12 col-md-6 col-lg-3 mb-2">

                <label for="end_request_cache_date" class="mb-2">

                    پایان بازه زمانی درخواست پول (هر ماه)

                    <sup class="input-error-validation">*</sup>

                </label>

                <input name="end_request_cache_date" id="end_request_cache_date" type="text" class="form-control rounded"
                       value="{{ $end_request_cache_date }}" placeholder="20">
                @error('end_request_cache_date')
                <p class="input-error-validation">{{ $message }}</p>
                @enderror
            </div>
            <div class="col-12 col-md-6 col-lg-3 mb-2">

                <label for="end_request_cache_date" class="mb-2">

                    حداقل مبلغ درخواستی جهت تسویه حساب(تومان)

                    <sup class="input-error-validation">*</sup>

                </label>

                <input name="minimum_refund_amount" id="minimum_refund_amount" type="text" class="form-control rounded"
                       value="{{ number_format($minimum_refund_amount) }}">
                @error('minimum_refund_amount')
                <p class="input-error-validation">{{ $message }}</p>
                @enderror
            </div>


            <div class="col-12 col-md-6 col-lg-3 mb-2">

                <label for="price_deal_cheque" class="mb-2">

                    مبلغ چک ضمانت (تومان)

                    <sup class="input-error-validation">*</sup>

                </label>

                <input name="price_deal_cheque" id="price_deal_cheque" type="text" class="form-control rounded"
                       value="{{ number_format($price_deal_cheque) }}">
                @error('price_deal_cheque')
                <p class="input-error-validation">{{ $message }}</p>
                @enderror
            </div>

        </div>
        <button class="btn btn-success btn-sm">
            update
        </button>
    </form>

@endsection



