@extends('admin.layout.index')

@section('title')
   برند
@endsection

@section('style')
   <style>
       .img-thumbnail{
           width: 70px;
           height: auto;
       }
       th{
           vertical-align: middle !important;
       }
   </style>
@endsection



@section('script')
<script>
    $('#add-brand').click(function(){
        $('#addBrand').modal('show');
    })
    
    
    $('#confirmExpertButton').click(function () {
            let expert_id = $('#Brand').val();
            // ارسال درخواست Ajax
            $.ajax({
                url: '{{ route('admin.representation.add.brand',['seller'=>$seller->id]) }}',
                type: 'POST',
                data: {
                    brand: expert_id,
                    _token: "{{ csrf_token() }}",

                },
                dataType: 'json',
            })
                .then((response) => {
                    console.log('عملیات با موفقیت انجام شد:', response);
                    if (response[0] == 1) {
                        $('#Gateway').modal('hide');
                        swal({
                            text: "برند با موفقیت اضافه شد",
                            icon: "success",
                            buttons: 'ok',
                        }).then(() => {

                            window.location.reload();

                        });
                    }
                    
                    if (response[0] == 0) {
                        $('#Gateway').modal('hide');
                        swal({
                            text: " برند تکراری نمیتوان اضافه کرد ",
                            icon: "error",
                            buttons: 'ok',
                        }).then(() => {

                            window.location.reload();

                        });
                    }
                })
                .fail((xhr, status, error) => {
                    console.error('خطا در ارسال درخواست:', error);
                    console.log('پاسخ:', xhr.responseText);
                });
        })

        $('#confirmExpertButtonClose').click(function () {
            $('#addBrand').modal('hide');
        })
</script>
@endsection

@section('content')

    <!-- Content Row -->
    <div class="row">

        <div class="col-xl-12 col-md-12 mb-4 p-4 bg-white">
            <div class="d-flex flex-column text-center flex-md-row justify-content-md-between mb-4">
                <h5 class="font-weight-bold mb-3 mb-md-0">برند های مرتبط    </h5>
                
                <button id="add-brand" class="btn btn-primary">
                    افزودن برند
                </button>
            </div>

            <div class="table-responsive">
                <table class="table table-bordered table-striped text-center">

                    <thead>
                    <tr>
                        <th>#</th>

                        <th>عنوان</th>

                        <th>وضعیت</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach ($brand as $key=>$item)
                        <tr>
                            <th>
                                {{ 1 + $key }}
                            </th>

                            <th>
                                {{ $item->Brand->name }}
                            </th>

                            <th>
                                <a href="{{ route('admin.representation.update.brand',['brand'=>$item->id]) }}" class="btn btn-sm btn-{{$item->is_active == 0 ? 'danger' : 'success'}}">
                                 {{$item->is_active == 0 ? 'غیرفعال': 'فعال'}}
                                </a>

                            </th>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

        </div>

    </div>
    
    <div class="modal fade" id="addBrand" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
               <p>

برند مربوطه را انتخاب کنید               </p>
                <hr>
                <select id="Brand" class="form-control form-control-sm" style="border: 1px solid #cecece">
                    
                    @foreach($brands as $item)
                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="confirmExpertButtonClose">بعدا</button>
                <button type="button" class="btn btn-primary" id="confirmExpertButton">تایید</button>
            </div>
        </div>
    </div>
</div>

@endsection
