@php
    $messages = $seller->messages()->orderBy('created_at','asc')->get()->groupBy(function ($message) {

        return $message->created_at->format('Y-m-d'); // گروه‌بندی بر اساس تاریخ

        });
@endphp

@foreach($messages as $date => $groupedMessages)

    <div id="date-{{ $date }}" class="text-center text-muted">
        {{ verta($date)->format('Y/m/d') }} <!-- نمایش تاریخ -->

    </div>
    @foreach($groupedMessages as $message)

        <div class="message {{ $message->is_admin ? 'admin' : 'user' }}">

            <div class="message-content">

                {{ $message->message }}

            </div>

            <div class="message-time"><span>

                    {{ verta($message->created_at)->format('H:i') }}

                </span></div>

        </div>

    @endforeach

@endforeach
