<div class="row">
    <div class="col-12 text-left">
        <div class="d-flex justify-content-between">
            <div>
                <span>وضعیت: </span>
                @include('admin.sellers.seller_status')
            </div>
            @if(isset($is_seller) and  $is_seller==0)
                <a title="بازگشت" href="{{ route('admin.representation.index') }}" class="btn btn-sm btn-secondary">
                    <i class="fa fa-arrow-left"></i>
                </a>
            @else
                <a title="بازگشت" href="{{ route('admin.my.representation') }}" class="btn btn-sm btn-secondary">
                    <i class="fa fa-arrow-left"></i>
                </a>
            @endif

        </div>
    </div>

    <div class="col-12 mb-5">
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link active" id="shop-info-tab" data-toggle="tab" href="#shop-info" role="tab"
                   aria-controls="shop-info" aria-selected="true">اطلاعات فروشگاه</a>
            </li>

            <li class="nav-item" role="presentation" onclick="ShowChat()">
                <a class="nav-link" id="chat-tab" data-toggle="tab" href="#chat" role="tab" aria-controls="chat"
                   aria-selected="false">چت و گفت و گو
                    @if($unread_messages > 0)
                        <span class="notification-badge">{{ $unread_messages }}</span>
                    @endif
                </a>
            </li>
            @if(request()->is('seller*'))
            <li class="nav-item" role="presentation">
                <a class="nav-link" id="password-edit-tab" data-toggle="tab" href="#password-edit" role="tab"
                   aria-controls="password-edit" aria-selected="true">رمز عبور ثابت</a>
            </li>
            @endif
            @if($seller->video != null)
            <li class="nav-item" role="presentation">
                <a class="nav-link " id="video-tab" data-toggle="tab" href="#video" role="tab"
                   aria-controls="video" aria-selected="true">امضاء قرارداد </a>
            </li>
            @endif
            <li class="nav-item" role="presentation">
                <a class="nav-link " id="order-tab" data-toggle="tab" href="#order" role="tab"
                   aria-controls="order" aria-selected="true">حق العمل </a>
            </li>
        </ul>
    </div>

    <div class="tab-content col-12" id="myTabContent">
        <div class="tab-pane fade show active" id="shop-info" role="tabpanel" aria-labelledby="shop-info-tab">
            @include('admin.sellers.seller_info')
        </div>
        <div class="tab-pane fade" id="chat" role="tabpanel" aria-labelledby="chat-tab">
            <div class="row d-flex justify-content-around">
                @include('admin.sellers.chat')
            </div>
        </div>
         @if($seller->video != null)
                <div class="tab-pane fade  " id="video" role="tabpanel" aria-labelledby="video-tab">

                    @if($seller->status  == 5 or ($seller->video != null and $seller->cheque != null))
                        @if(auth()->guard('web')->check() and auth()->guard('web')->user()->role == 1 )
                            <div class="d-block text-left">
                                <a class="btn btn-success " href="{{route('seller.accept.video',['seller'=>$seller->id])}}">تایید نماینده</a>
                            </div>
                        @endif
                    @endif

                    <hr/>
                    <h4>ویدئو و چک ارسالی:</h4>

                        <div class="row">
                            <div class="col-6">
                                <video width="640" height="480" controls>
                                    <source src="{{ imageExist(env('VIDEO_SELLER'),$seller->video) }}" type="video/mp4">
                                    مرورگر شما از ویدئو پشتیبانی نمی‌کند.
                                </video>
                            </div>
                            <div class="col-6">
                                <div class="w-100">
                                    <img class="img-fluid"  src="{{ imageExist(env('CHEQUE_SELLER'),$seller->cheque) }}">
                                </div>

                            </div>
                        </div>

                    <hr/>
                    <h4>قرار داد امضا شده :</h4>

                    <div>
              <a href="{{route('generate.pdf',['seller'=>$seller->id])}}" class="btn btn-primary" >
                  <i class="fa fa-download"></i>
                  دانلود قرار داد</a>


                    </div>
        </div>
        @endif
        @if(request()->is('seller*'))
            @include('seller.change_password')
        @endif
        <div class="tab-pane fade" id="order" role="tabpanel" aria-labelledby="order-tab">
            <div class="row d-flex justify-content-around">
                @include('admin.sellers.orders')
            </div>
        </div>
    </div>
</div>

<!-- Modal Confirmation -->
<div class="modal fade" id="confirmationModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <p id="confirmationModalText"></p>
                <p>آیا مطمئن هستید که می‌خواهید ادامه دهید؟</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal" id="CloseConfirmationModal">خیر
                </button>
                <button type="button" class="btn btn-primary" id="confirmBtn">بله</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Confirmation -->
<div class="modal fade" id="RejectedSellerModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <p id="confirmationModalText"></p>
                <p>فرم کاربر مورد نظر <strong class="text-danger">رد</strong> خواهد شد. ادامه دهید؟</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal" id="RejectedSellerModalDismiss">خیر
                </button>
                <button type="button" class="btn btn-primary" id="RejectedSellerModalBTN">بله</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Warning -->
<div class="modal fade" id="warningModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <!-- پیام اخطار -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">خیر</button>
                <button type="button" class="btn btn-primary" id="confirmSendButton">بله</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Warning -->
<div class="modal fade" id="َAssignExpert" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
               <p>
                   کارشناس فروش مربوط به این نماینده را مشخص کنید
               </p>
                <hr>
                <select id="Expert" class="form-control form-control-sm" style="border: 1px solid #cecece">
                    <option value="0">هیچ</option>
                    @foreach($sale_experts as $sale_expert)
                        <option value="{{ $sale_expert->id }}">{{ $sale_expert->first_name.' '.$sale_expert->last_name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="confirmExpertButtonClose">بعدا</button>
                <button type="button" class="btn btn-primary" id="confirmExpertButton">تایید</button>
            </div>
        </div>
    </div>
</div>
