@php

    $total_commission = 0;

    // محاسبه پورسانت برای هر سفارش و جمع کردن آن‌ها
    foreach ($orders as $order) {
        // محاسبه پورسانت برای هر سفارش
        $commissionAmount = ($order->total_amount * $order->commission) / 100;

        // جمع کردن پورسانت‌ها
        $total_commission += $commissionAmount;
    }
@endphp
<div class="row p-5 bg-white">
    <div class="col-12">
        <div id="totalSale" class="alert alert-info text-center">
            مقدار کل حق العمل برابر با {{ number_format($total_commission) }} تومان میباشد
        </div>
    </div>
</div>
<div id="orders">
    <div id="orderReports" class="table-responsive">
        <table class="table table-bordered table-striped text-center">
            <thead>
            <tr class="bg-dark text-white">
                <th class=" text-white">#</th>
                <th class=" text-white">نام کاربر</th>
                <th class=" text-white">کیف پول (تومان)</th>
                <th class=" text-white">قابل پرداخت (تومان)</th>
                <th class=" text-white">کل (تومان)</th>
                <th class=" text-white">نوع پرداخت</th>
                <th class=" text-white">وضعیت تراکنش</th>
                <th class=" text-white">تاریخ</th>
                @if(request()->is('admin-panel/management/orders'))
                    <th class=" text-white">SMS</th>
                @endif
                <th class=" text-white">وضعیت سفارش</th>
                @if ($orders->contains(fn($order) => $order->request_id != 0))
                <!-- اضافه کردن شرط -->
                    <th class=" text-white">وضعیت اعتبار</th> <!-- اضافه کردن ستون در صورت قسطی بودن -->
                @endif
                <th class=" text-white">شماره سفارش</th>

                <th class=" text-white">حق العمل</th>
            </tr>
            </thead>
            <tbody>
            @foreach ($orders as $key => $order)
                <tr>
                    <td>
                        @if($orders->has('firstItem'))
                            {{ $orders->firstItem() + $key }}

                        @else
                            {{ $key }}
                        @endif

                    </td>
                    <td>
                        @if(isset($order->user->id))
                            @if(auth()->guard('web')->check())
                                <a href="{{ route('admin.user.edit',['user'=>$order->user->id]) }}">
                                    {{ $order->user->first_name == null ? $order->user->cellphone : $order->user->first_name.' '.$order->user->last_name }}
                                </a>
                            @else
                                <a >
                                    {{ $order->user->first_name == null ? $order->user->cellphone : $order->user->first_name.' '.$order->user->last_name }}
                                </a>
                            @endif

                        @else
                            -
                        @endif

                    </td>
                    <td>
                        {{ number_format($order->wallet) }}
                    </td>
                    <td>
                        {{ number_format($order->paying_amount) }}
                    </td>
                    <td>
                        {{ number_format($order->total_amount) }}
                    </td>
                    <td>
                        {{ $order->paymentMethod->title }}
                        @if($order->paymentMethod->id==3 and $order->image!=null)
                            <a target="_blank" href="{{ imageExist(env('ORDER_IMAGE_UPLOAD_PATH'),$order->image) }}">
                                <i class="fa fa-paperclip"></i>
                            </a>
                        @endif
                    </td>
                    <td>
                        {{ $order->payment_status }}
                    </td>
                    <td>
                        {{ verta($order->created_at)->format('%d %B ,Y') }}
                    </td>
                    @if(request()->is('admin-panel/management/orders'))
                        <td>
                            <a title="ارسال پیامک تغییر وضعیت" id="active_sms_icon_{{ $order->id }}"
                               onclick="active_sms({{ $order->id }})"
                               class="btn btn-sm {{ $order->getRawOriginal('active_sms')==1 ? 'btn-success text-white' : 'btn-dark' }}">
                                {{ $order->active_sms }}
                            </a>
                        </td>
                    @endif
                    <td>
                        <select @if(request()->is('admin-panel/management/orders')) @else disabled
                                @endif onchange="changeOrderStatus(this,{{ $order->id }},{{ $order->paymentMethod->id }})"
                                class="form-control form-control-sm">
                            @foreach($order_status as $item)
                                @if($item->id == 7 and $order->payment_type != 3)
                                    @break
                                @endif
                                <option
                                    {{ $order->delivery_status==$item->id ? 'selected' : ' ' }} value="{{ $item->id }}">
                                    {{ $item->title }}
                                </option>
                            @endforeach
                        </select>
                    </td>
                    @if ($orders->contains(fn($order) => $order->request_id != 0))
                    <!-- اضافه کردن شرط -->
                        <td>
                            @if($order->InstallmentRequest !=  null)
                                <p class="{{getStatusClass($order->InstallmentRequest->status)}}">

                                    {{$order->InstallmentRequest->status}}
                                </p>
                            @endif
                        </td>
                    @endif
                    <td>
                        {{ $setting->productCode.'-'.$order->order_number }}
                    </td>

                    <td>
                        {{$order->Commission($order->id)}}
                        تومان

                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
</div>
