@extends('admin.layout.index')

@section('title')
    لیست درخواست های تسویه
@endsection

@section('style')
    <style>
        @media (min-width: 1400px) {
            .container-xxl, .container-xl, .container-lg, .container-md, .container-sm, .container {
                max-width: 1635px !important;
            }
        }

        .input-error-validation {
            color: red;
            font-size: 9pt;
            display: none;
        }

        #NotFound {
            display: none;
        }

        #overlay {
            display: none;
            text-align: center;
        }

        .align-center {
            align-items: center !important
        }

        .mb-0 {
            margin-bottom: 0 !important;
        }

        .error_message {
            font-size: 9pt;
            color: red;
            position: absolute;
            top: 40px;
            right: 0;
        }

        .form-group {
            margin-bottom: 0 !important;
            padding: 0 !important;
        }

        th {
            color: #fff !important;
            text-align: center;

        }

        .errors {
            font-size: 9pt;
            color: red;
            margin-top: 5px;
        }
    </style>

@endsection

@section('script')

    <script>
        $('#report_order_btn').click(function () {
            $('#start_date_error').hide();
            $('#end_date_error').hide();
        })
        //get pagination
        var todayPagination = null;
        var thisWeekPagination = null;
        var thisMonthPagination = null;
        var lastMonthPagination = null;
        var order_start = null;
        var order_end = null;

        function pagination(totalPages, currentPage) {
            var pagelist = "";
            if (totalPages > 1) {
                currentPage = parseInt(currentPage);
                pagelist += `<ul style="list-style: none" class="pagination_ajax justify-content-center d-flex">`;
                const prevClass = currentPage == 1 ? " disabled" : "";
                pagelist += `<li class="page-item${prevClass}"><a class="page-link" data-page="${currentPage - 1}" href="#"><</a></li>`;
                for (let p = 1; p <= totalPages; p++) {
                    const activeClass = currentPage == p ? " active" : "";
                    pagelist += `<li class="page-item${activeClass}"><a class="page-link" href="#" data-page="${p}">${p}</a></li>`;
                }
                const nextClass = currentPage == totalPages ? " disabled" : "";
                pagelist += `<li class="page-item${nextClass}"><a class="page-link" data-page="${currentPage + 1}" href="#">></a></li>`;
                pagelist += `</ul>`;
            }
            $("#pagination").html(pagelist);
        }

        // pagination
        $(document).on("click", "ul.pagination_ajax li a", function (e) {
            e.preventDefault();
            var $this = $(this);
            const pagenum = $this.data("page");
            $("#currentPage").val(pagenum);
            getOrderReport(todayPagination, thisWeekPagination, thisMonthPagination, lastMonthPagination, 'paginate');
        });

        //calculateIndexRow
        function calculateIndexRow(pageNo, row_per_page, key) {
            if (pageNo > 1) {
                pageNo = pageNo;
            } else {
                pageNo = 1;
            }
            return ((pageNo - 1) * (row_per_page)) + (key + 1);
        }

        function getOrderReport(today = null, thisWeek = null, thisMonth = null, lastMonth = null, paginate = null) {
            let currentPage = $('#currentPage').val();
            todayPagination = today;
            thisWeekPagination = thisWeek;
            thisMonthPagination = thisMonth;
            lastMonthPagination = lastMonth;
            if (paginate == null) {
                order_start = $('#order_start_input').val();
                order_end = $('#order_end_input').val();
            }
            if (order_start == '' && today == null && thisWeek == null && thisMonth == null && lastMonth == null && paginate == null) {
                $('#start_date_error').show()
            } else if (order_end == '' && today == null && thisWeek == null && thisMonth == null && lastMonth == null && paginate == null) {
                $('#end_date_error').show()
            } else {
                $.ajax({
                    url: "{{ route('home.seller.orders.get') }}",
                    data: {
                        order_start: order_start,
                        order_end: order_end,
                        today: today,
                        thisWeek: thisWeek,
                        thisMonth: thisMonth,
                        lastMonth: lastMonth,
                        page: currentPage,
                        _token: "{{ csrf_token() }}",
                    },
                    dataType: "json",
                    type: "POST",
                    beforeSend: function () {
                        $("#overlay").fadeIn();
                    },
                    success: function (msg) {
                        if (msg) {
                            $("#Auto_paginate").html('');
                            if (msg[0] = 'ok') {
                                let row;
                                let orders = msg[1];
                                let massage = msg[4];
                                if (orders.length == 0) {
                                    $('#totalSale').text(massage);
                                    $('#totalSale').show();
                                    $('#orderReports').hide();
                                    $("#pagination").html('');

                                } else {
                                    $('#NotFound').hide();
                                    $('#orderReports').show();
                                    $('#orders').html(orders);
                                    let totalRows = msg[2];
                                    let row_per_page = msg[3];
                                    let massage = msg[4];
                                    let totalPages = Math.ceil(totalRows / row_per_page);
                                    const currentPage = $('#currentPage').val();
                                    pagination(totalPages, currentPage);

                                    $('#totalSale').text(massage);
                                    $('#totalSale').show();
                                }
                                $('#filter_order_modal').modal('hide');
                                $('#order_start_input').val('');
                                $('#order_end_input').val('');

                            }
                        }
                        $("#overlay").fadeOut();
                    },
                    fail: function (error) {
                        console.log(error);
                        $("#overlay").fadeOut();
                    }
                })
            }
        }

        function getOrderReportWithStatus(status, type) {
            let currentPage = $('#currentPage').val();
            $.ajax({
                url: "{{ route('admin.orders.get_with_status') }}",
                data: {
                    page: currentPage,
                    status: status,
                    type: type,
                    _token: "{{ csrf_token() }}",
                },
                dataType: "json",
                type: "POST",
                beforeSend: function () {
                    $("#overlay").fadeIn();
                },
                success: function (msg) {
                    if (msg) {
                        $("#Auto_paginate").html('');
                        if (msg[0] = 'ok') {
                            let row;
                            let orders = msg[1];
                            let massage = msg[4];
                            if (orders.length == 0) {
                                $('#totalSale').text(massage);
                                $('#totalSale').show();
                                $('#orderReports').hide();
                                $("#pagination").html('');

                            } else {
                                $('#NotFound').hide();
                                $('#orderReports').show();
                                $('#orders').html(orders);
                                let totalRows = msg[2];
                                let row_per_page = msg[3];
                                let massage = msg[4];
                                let totalPages = Math.ceil(totalRows / row_per_page);
                                const currentPage = $('#currentPage').val();
                                pagination(totalPages, currentPage);

                                $('#totalSale').text(massage);
                                $('#totalSale').show();
                            }
                            $('#filter_order_modal').modal('hide');
                            $('#order_start_input').val('');
                            $('#order_end_input').val('');

                        }
                    }
                    $("#overlay").fadeOut();
                },
                fail: function (error) {
                    console.log(error);
                    $("#overlay").fadeOut();
                }
            })
        }

        function createTableRow(order, key) {
            let pageNo = $('#currentPage').val();
            let row_per_page = 100;
            let indexRow = calculateIndexRow(pageNo, row_per_page, key);
            let url = "{{ route('admin.orders.show',":id") }}";
            url = url.replace(':id', order.id);
            let printUrl = "{{ route('admin.orders.print', ":printUrl_id") }}";
            printUrl = printUrl.replace(':printUrl_id', order.id);
            let printPeykUrl = "{{ route('admin.orders.print_peyk', ":printPeykUrl_id") }}";
            printPeykUrl = printPeykUrl.replace(':printPeykUrl_id', order.id);
            let html = `<tr>
                            <th>${indexRow}</th>
                            <th>${order.user.name}</th>
                            <th>${number_format(order.wallet)}</th>
                            <th>${number_format(order.paying_amount)}</th>
                            <th>${number_format(order.total_amount)}</th>
                            <th>${order.payment_type}</th>
                            <th>${order.payment_status}</th>
                            <th>${order.date}</th>
                            <th>${order.delivery_status}</th>
                            <th>${order.order_number}</th>
                            <th>${order.status}</th>
                            <th>
                                  <a class="btn btn-sm btn-success"
                                   href="${url}">
                                    <i class="fa fa-eye"></i>
                                </a>
                                <a target="_blank" class="btn btn-sm btn-dark"
                                   href="${printUrl}">
                                    <i class="fa fa-print"></i>
                                </a>
                                <a target="_blank" class="btn btn-sm btn-dark"
                                   href="${printPeykUrl}">
                                    <i class="fa fa-motorcycle"></i>
                                </a>
                            </th>
                        </tr>`;
            return html;
        }

        //excel output order

        const order_start_excel = new mds.MdsPersianDateTimePicker(document.getElementById('order_start_excel'), {
            targetTextSelector: '#order_start_input_excel',

            englishNumber: true,

            enableTimePicker: true,

            textFormat: 'yyyy-MM-dd HH:mm:ss',

        });


        const order_end_excel = new mds.MdsPersianDateTimePicker(document.getElementById('order_end_excel'), {
            targetTextSelector: `#order_end_input_excel`,
            englishNumber: true,
            enableTimePicker: true,
            textFormat: 'yyyy-MM-dd HH:mm:ss',
        });
        //

        new mds.MdsPersianDateTimePicker(document.getElementById('order_start'), {
            targetTextSelector: `#order_start_input`,
            englishNumber: true,
            enableTimePicker: true,
            textFormat: 'yyyy-MM-dd HH:mm:ss',
        });

        new mds.MdsPersianDateTimePicker(document.getElementById('order_end'), {
            targetTextSelector: `#order_end_input`,
            englishNumber: true,
            enableTimePicker: true,
            textFormat: 'yyyy-MM-dd HH:mm:ss',
        });

        function number_format(number, decimals, dec_point, thousands_sep) {
            // Strip all characters but numerical ones.
            number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
            var n = !isFinite(+number) ? 0 : +number,
                prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
                sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
                dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
                s = '',
                toFixedFix = function (n, prec) {
                    var k = Math.pow(10, prec);
                    return '' + Math.round(n * k) / k;
                };
            // Fix for IE parseFloat(0.55).toFixed(0) = 0;
            s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
            if (s[0].length > 3) {
                s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
            }
            if ((s[1] || '').length < prec) {
                s[1] = s[1] || '';
                s[1] += new Array(prec - s[1].length + 1).join('0');
            }
            return s.join(dec);
        }

        function changeOrderStatus(tag, order_id, deliveryMethod_id) {
            let delivery_status = $(tag).val();
            $.ajax({
                url: "{{ route('admin.orders.update_delivery_status') }}",
                data: {
                    delivery_status: delivery_status,
                    _token: "{{ csrf_token() }}",
                    order_id: order_id,
                    deliveryMethod_id: deliveryMethod_id,
                },
                dataType: 'json',
                type: 'POST',
                beforeSend: function () {

                },
                success: function (msg) {
                    if (msg) {
                        if (msg[0] == 'ok') {
                            swal({
                                title: 'با تشکر',
                                text: 'وضعیت سفارش با موفقیت تغییر یافت',
                                icon: 'success',
                                timer: 3000,
                            })
                        } else {
                            swal({
                                title: 'SMS',
                                text: msg[1],
                                icon: 'error',
                                buttons: 'ok',
                            })
                        }
                    }
                },
                fail: function () {

                },
                error: function () {

                }
            })
        }

        function active_sms(order_id) {
            let selector = '#active_sms_icon_' + order_id;
            $.ajax({
                url: "{{ route('admin.order.active_sms') }}",
                data: {
                    _token: "{{ csrf_token() }}",
                    order_id: order_id,
                },
                dataType: "json",
                type: 'POST',
                beforeSend: function () {
                    $("#overlay").fadeIn();
                },
                success: function (msg) {
                    if (msg) {
                        if (msg[1] === 1) {
                            $(selector).removeClass('btn-dark');
                            $(selector).addClass('btn-success text-white');
                            $(selector).text('فعال');
                        }
                        if (msg[1] === 0) {
                            $(selector).removeClass('btn-success text-white');
                            $(selector).addClass('btn-dark');
                            $(selector).text('غیر فعال');
                        }
                    }
                    $("#overlay").fadeOut();

                },
                fail: function (error) {
                    console.log(error);
                    $("#overlay").fadeOut();
                }
            })
        }

        function RemoveModal(order_id) {
            let modal = $('#remove_modal');
            modal.modal('show');
            $('#order_id').val(order_id);
        }

        function RemoveOrder() {
            let order_id = $('#order_id').val();
            $.ajax({
                url: "{{ route('admin.order.remove') }}",
                data: {
                    _token: "{{ csrf_token() }}",
                    order_id: order_id,
                },
                dataType: "json",
                type: 'POST',
                beforeSend: function () {

                },
                success: function (msg) {
                    if (msg) {
                        let message = msg[1];
                        if (msg[0] == 0) {
                            swal({
                                title: 'ERROR',
                                text: message,
                                icon: 'error',
                                buttons: 'ok',
                            })
                        }
                        if (msg[0] == 1) {

                            swal({
                                title: 'باتشکر',
                                text: message,
                                icon: 'success',
                                timer: 3000,
                            })
                            window.location.reload();
                        }
                    }
                },
            })
        }

        function custom_pagination(tag) {
            let per_page = $(tag).val();
            let payment_methods = $('#payment-methods').val();
            let url = '{{ route('admin.orders.pagination',['payment_methods'=>':payment-methods','show_per_page'=>':per_page']) }}';
            url = url.replace(':per_page', per_page);
            url = url.replace(':payment-methods', payment_methods);
            window.location.href = url;
        }

        function custom_methods(tag) {
            let per_page = $('#custom_pagination').val();
            let payment_methods = $(tag).val();
            let url = '{{ route('admin.orders.pagination',['payment_methods'=>':payment-methods','show_per_page'=>':per_page']) }}';
            url = url.replace(':payment-methods', payment_methods);
            url = url.replace(':per_page', per_page);
            window.location.href = url;
        }

        function SearchOrder(e, tag) {
            if (e.keyCode == 13) {
                let keyWord = $(tag).val();
                $.ajax({
                    url: "{{ route('admin.orders.searchKeyWord') }}",
                    data: {
                        _token: "{{ csrf_token() }}",
                        'keyWord': keyWord,
                    },
                    dataType: "json",
                    method: "post",
                    beforeSend: function () {
                        $("#overlay").fadeIn();
                    },
                    success: function (msg) {
                        if (msg) {
                            $("#Auto_paginate").html('');
                            if (msg[0] = 'ok') {
                                let row;
                                let orders = msg[1];
                                let massage = msg[4];
                                if (orders.length == 0) {
                                    $('#totalSale').text(massage);
                                    $('#totalSale').show();
                                    $('#orderReports').hide();
                                    $("#pagination").html('');

                                } else {
                                    $('#NotFound').hide();
                                    $('#orderReports').show();
                                    $('#orders').html(orders);
                                    let totalRows = msg[2];
                                    let row_per_page = msg[3];
                                    let massage = msg[4];
                                    let totalPages = Math.ceil(totalRows / row_per_page);
                                    const currentPage = $('#currentPage').val();
                                    pagination(totalPages, currentPage);

                                    $('#totalSale').text(massage);
                                    $('#totalSale').show();
                                }
                                $('#filter_order_modal').modal('hide');
                                $('#order_start_input').val('');
                                $('#order_end_input').val('');

                            }
                        }
                        $("#overlay").fadeOut();
                    },
                })
            }
        }

        {{--function AddWallet() {--}}
        {{--    let can_refund = '{{ $can_refund }}';--}}
        {{--    if (can_refund == 1) {--}}
        {{--        show_refund_modal();--}}
        {{--    } else {--}}
        {{--        show_error_modal();--}}
        {{--    }--}}
        {{--}--}}

        function show_refund_modal() {
            let success_refund = $('#success_refund');
            success_refund.modal('show');
        }

        function CloseSuccessRefund() {
            let success_refund = $('#success_refund');
            success_refund.modal('hide');
        }

        function show_error_modal() {
            let error_refund = $('#error_refund');
            error_refund.modal('show');
        }

        function CloseErrorRefund() {
            let error_refund = $('#error_refund');
            error_refund.modal('hide');
        }

        {{--function ConfirmRefund() {--}}
        {{--    let seller = "{{ $seller->id }}";--}}
        {{--    let url = "{{ route('seller.request.refund') }}";--}}
        {{--    $.ajax({--}}
        {{--        url: url,--}}
        {{--        data: {--}}
        {{--            seller: seller,--}}
        {{--            _token: "{{ csrf_token() }}",--}}
        {{--        },--}}
        {{--        dataType: 'json',--}}
        {{--        method: 'POST',--}}
        {{--        success: function (msg) {--}}
        {{--            if (msg[0] == 1) {--}}
        {{--                window.location.reload();--}}
        {{--            }--}}
        {{--        }--}}
        {{--    });--}}
        {{--}--}}

        function ChangeCardNo() {
            let success_refund = $('#success_refund');
            let change_card_no = $('#change_card_no');
            success_refund.modal('hide');
            change_card_no.modal('show');

        }

        function ChangeInfo() {
            let card_no = $('#card_no').val();
            let sheba_no = $('#sheba_no').val();
            let url = "{{ route('seller.refund.changeCardNo') }}";
            $.ajax({
                url: url,
                data: {
                    sheba_no: sheba_no,
                    card_no: card_no,
                    _token: "{{ csrf_token() }}",
                },
                dataType: 'json',
                method: 'POST',
                success: function (msg) {
                    if (msg[0] == 1) {
                        let html = '<div class="p-3"><div style="margin: 0" class="alert alert-success text-center">شماره حساب با موفقیت تغییر یافت</div></div>';
                        $('#card_no_alert').html(html);
                        setTimeout(function () {
                            window.location.reload();
                        }, 1000);
                    }
                },
                error: function (msg) {
                    let errors = msg.responseJSON.errors;
                    $.each(errors, function (i, val) {
                        $('#error_' + i).removeClass('d-none');
                        $('#error_' + i).text(val[0]);
                    })
                }

            });
        }

        function checkShebaNo(tag) {
            let value = $(tag).val();
            value = value.replaceAll('i', '');
            value = value.replaceAll('I', '');
            value = value.replaceAll('R', '');
            value = value.replaceAll('r', '');
            $(tag).val(value);
        }

        function CloseChangeInfo() {
            let change_card_no = $('#change_card_no');
            change_card_no.modal('hide');
        }

        function ChangeRefundStatus(id, tag) {
            let new_status = $(tag).val();
            let url = '{{ route('admin.representation.refund_requests_change_status') }}';
            $.ajax({
                url: url,
                data: {
                    id: id,
                    new_status: new_status,
                    _token: "{{ csrf_token() }}",
                },
                dataType: 'json',
                method: 'POST',
                success: function (msg) {
                    if (msg[0] == 1) {
                        window.location.reload();
                    }
                },
                error: function (msg) {
                    alert('Error');
                }

            });
        }

    </script>
@endsection

@section('content')
    <div class="col-xl-12 col-md-12 mb-4 p-4 bg-white">
        <!--<div class="row">-->
        <!--    <div class="col-12">-->
        <!--        <div class="d-flex flex-column text-center flex-md-row justify-content-md-between mb-4">-->
        <!--            <h5 class="font-weight-bold mb-3 mb-md-0">-->
        <!--                کیف پول و درخواست ها-->
        <!--            </h5>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
        <!--<hr>-->
        <div class="d-flex justify-content-between align-center">
            {{--            <span>موجودی کیف پول : {{ number_format($wallet) }} تومان</span>--}}
            {{--            <button onclick="AddWallet()" type="button" class="btn btn-sm btn-danger">درخواست تسویه</button>--}}
        </div>
    </div>
    <hr>
    <div class="table-responsive">
        <table class="table table-bordered table-striped text-center">

            <thead>
            <tr class="bg-dark">
                <th>#</th>
                <th>
                    نماینده
                </th>
                <th>مبلغ درخواستی (تومان)</th>
                <th>
                    شماره شبا
                </th>
                <th>
                    شماره کارت
                </th>
                <th>تاریخ</th>
                <th>تغییر وضعیت</th>
            </tr>
            </thead>
            <tbody>
            @foreach ($items as $key => $item)
                <tr>
                    <th class="text-dark">
                        {{ $key }}
                    </th>
                    <th class="text-dark">
                        {{ $item->Seller->first_name.' '.$item->Seller->last_name }}
                    </th>
                    <th class="text-dark">
                        {{ number_format($item->amount) }}
                    </th>
                    <th class="text-dark">
                        {{ $item->sheba_no }}
                    </th>
                    <th class="text-dark">
                        {{ $item->card_no }}
                    </th>
                    <th class="text-dark">
                        {{ verta($item->created_at)->format('Y-m-d H:i') }}
                    </th>
                    <th class="text-dark">
                        <select onchange="ChangeRefundStatus({{ $item->id }},this)"
                                {{ $item->status!=0 ? 'disabled' : ''}} class="form-control">
                            @foreach($statuses as $status)
                                <option
                                    {{ $item->Status->id==$status->id ? 'selected' : '' }} value="{{ $status->id}}">{{ $status->title }}</option>
                            @endforeach
                        </select>
                    </th>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-center mt-5">
        {{--            {{ $wallet_history->render() }}--}}
    </div>

    {{--    @include('seller.refund.error_modal')--}}
    {{--    @include('seller.refund.refund_modal')--}}
    {{--    @include('seller.refund.change_card_no_modal')--}}
@endsection
