@foreach($items as $key=>$item)
    <tr>
        <td>
            @if(method_exists($items, 'firstItem'))
                {{ $items->firstItem() + $key }}
            @else
                {{ $key+1 }}
            @endif
        </td>
        <td>
            {{ $item->first_name.' '.$item->last_name }}
        </td>
        <td>
            {{ $item->national_code }}
        </td>
        <td>
            {{ $item->cellphone }}
        </td>
<td>

        <select id="expert-select-{{ $item->id }}" class="form-control form-control-sm">
            <option value="0" {{ $item->expert_id == 0 ? 'selected' : '' }}>هیچ</option>
            @foreach($experts as $expert)
                <option value="{{ $expert->id }}" {{ $item->expert_id == $expert->id ? 'selected' : '' }}>
                    {{ $expert->first_name . ' ' . $expert->last_name }}
                </option>
            @endforeach
        </select>

</td>
<script>
    // استفاده از jQuery برای مدیریت تغییرات سلکت باکس
    document.querySelector('#expert-select-{{ $item->id }}').addEventListener('change', function() {
        var expert_id = this.value;
        var representation_id = {{ $item->id }};

        // ارسال درخواست AJAX به سرور
        fetch('{{ route('admin.representation.update.expert', '') }}' + '/' + representation_id, {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            },
            body: JSON.stringify({
                expert_id: expert_id,
            }),
        })
        .then(response => response.json())
        .then(data => {
            // نمایش پیام موفقیت یا خطا (در صورت نیاز)
            if (data.success) {
                alert('کارشناس فروش با موفقیت تغییر کرد.');
            } else {
                alert('مشکلی پیش آمد.');
            }
        })
        .catch(error => console.error('Error:', error));
    });
</script>
        <td>
          @include('admin.sellers.seller_status')
        </td>
        <td>
            <a href="{{ route('admin.representation.edit',['id'=>$item->id]) }}"
               class="btn btn-info btn-sm">
                <i class="fa fa-list"></i>
            </a>
               <a href="{{ route('admin.representation.edit.gateway',['seller'=>$item->id]) }}"
               class="btn btn-warning btn-sm">
                <i class="fa  fa-credit-card"></i>
            </a>
            
                           <a href="{{ route('admin.representation.edit.brand',['seller'=>$item->id]) }}"
               class="btn btn-primary btn-sm">
                <i class="fa  fa-shop"></i>
            </a>
        </td>
    </tr>
@endforeach
